// Chip8 Emulator.cpp : Defines the entry point for the console application.
//

//#include "stdafx.h"
#include <xtl.h>
#include "main.h"
#include "Direct3D.h"
#include "DirectInput.h"
#include <stdlib.h>
#include <time.h>
#include <vector>
#include <string>
//#include <Mmsystem.h>
using namespace std;
#define _COMPILING_CHIP8
#include "Chip8 Headers.h"
#include "Chip8 Emulator.h"
#include "Opcodes.h"
#undef _COMPILING_CHIP8

extern HINSTANCE hInst;
extern HWND hWnd;

int m_StreamSample = 0 ;
DWORD tLast;
bool bRomLoaded = false;

void (*JumpTableBasic[])() = 
{
	Various,		  // Various opcodes (0x0XXX)
	Jump_XXX,		  // Jump to XXX (0x1XXX)
	Jump_Sub,		  // Jump to subroutine at XXX (0x2XXX)
	Skip_Reg_Eq_XXX,  // Skip if register X = XXX (0x3XXX)
	Skip_Reg_NEq_XXX, // Skip if register X <> XXX (0x4XXX)
	Skip_Reg_Eq_Reg,  // Skip if register X = register Y (0x5XXX)
	Move_Reg_XXX,	  // Move XXX to register X (0x6XXX)
	Add_Reg_XXX,	  // Add XXX to register X (0x7XXX)
	Math,			  // Math opcodes (0x8XXX)
	Skip_Reg_NEq_Reg, // Skip if register X <> register Y (0x9XXX)
	Load_I_XXX,		  // Load I with XXX (0xAXXX)
	Jump_XXX_V0,	  // Jump to XXX + V[0] (0xBXXX)
	Rand_Number,	  // Move random number <= XXX to register X (0xCXXX)
	Draw,			  // Draw sprite (0xDXXX)
	Skip_Key,		  // Key opcodes (0xEXXX)
	System			  // Various opcodes (0xFXXX)
};

void (*JumpTableMath[])() =
{
	Math_Move_XY,	   // Move reg Y into reg X (0x8XX0)
	Math_OR,		   // OR reg X with reg Y (0x8XX1)
	Math_AND,		   // AND reg X with reg Y (0x8XX2)
	Math_XOR,		   // XOR reg X with reg Y (0x8XX3)
	Math_Add_XY_Carry, // Add Y to X (w/carry) (0x8XX4)
	Math_Sub_XY_Carry, // Subtract X with Y (w/carry) (0x8XX5)
	Math_Shift_Right,  // Shift reg X right 1 bit (0x8XX6)
	Math_Sub_YX,	   // Subtract reg Y with reg X, result in reg X (0x8XX7)
	UnknownInstruction, 
	UnknownInstruction,
	UnknownInstruction,
	UnknownInstruction,
	UnknownInstruction,
	UnknownInstruction,
	Math_Shift_Left,   // Shift reg X left 1 bit (0x8XXE)
	UnknownInstruction
};

#pragma warning (disable: 4312)
inline void valid_addr_or_op(uint offset,check_type type)
{	
	//TRACE("CPU: Checking for invalid emulation status...\n");
	char buffer[100];
	char msg[10000];
	bool bOpError = false;
	bool bOffsetError = false;
	bool bJumpError = false;
	bool bSChip8 = false;
	bool bZeroMemory = false;
	if (type == type_offset)
	{
		if (offset < 0x200) 
		{
			strcpy(buffer,"Trying to jump to interpreter memory!\n");
			bOffsetError=true;
		} else if (offset > rom_length) {
			strcpy(buffer,"Trying to jump beyond rom data!\n");
			bOffsetError=true;
		}
	} else if (type == type_opcode) {
		if (PC > rom_length)
		{
			strcpy(buffer,"Trying to execute opcodes beyond rom memory at ");
			bOpError=true;
		} else if (PC < 0x200) {
			strcpy(buffer,"Trying to execute opcodes in interpreter memory at ");
			bOpError=true;
		} else if (offset==0) {
			strcpy(buffer,"Zero data memory encountered at ");
			bZeroMemory=true;
		}
	} else if (type == type_jumpcheck) {
		if (iRoutinesJumped == 0)
		{
			strcpy(buffer,"Trying to return from a sub-routine when no sub-routine jump has been made!\n");
			bJumpError=true;
		} else if (iRoutinesJumped==16) {
			strcpy(buffer,"Trying to jump to a sub-routine, but maximum sub-routine jumps has been reached!\n");
			bJumpError=true;
		}
	}
	if (!bOpError && !bOffsetError && !bJumpError && !bSChip8 
		&& !bZeroMemory)
		return;

	if (bOpError)
	{
		wsprintf(msg,"%s0x%X!\nLast opcode processed was 0x%X at location 0x%X.\nRom memory is mapped at 0x200 through 0x%X.",
		buffer,PC,lastOpcode,lastPC,rom_length);
	} else if (bZeroMemory) {
		wsprintf(msg,"%s0x%X!\n",buffer,PC);
	} else if (bSChip8) {
		wsprintf(msg,"%s0x%0000 at 0x%X!\nSuper Chip8 roms are not supported! Emulation will halt.",
			buffer,offset,PC);
	} else if (bOffsetError) {
		wsprintf(msg,"%sJump address: 0x%X.\nRom memory is mapped at 0x200 through 0x%X.\nLast opcode was 0x%X, processed at location 0x%X.",
			buffer,offset,rom_length,lastOpcode,lastPC);
	} else if (bJumpError) {
		wsprintf(msg,"%sTrying to return to address at 0x%X from address 0x%X.",
			buffer,offset,PC);
	}

	if (!bZeroMemory)
	{
		wsprintf(msg,"%s\nCannot recover from critical error; terminating...",
			msg);
	}
	//RenderText(msg,DT_CRITICAL_ERROR|QUIT_EMULATOR);
}
#pragma warning (default: 4312 4311)

void UnknownInstruction()
{
	//TRACE("CPU: Unknown instruction found!\n");
	if (opcode == 0x0)
		return; // Zero data memory error
#if 0
	char msg[1000];
	wsprintf(msg,"Rom is trying to execute unknown opcode 0x%0.4X"
		" at address 0x%X.\n",opcode,PC);
	RenderText(msg,DT_CRITICAL_ERROR|QUIT_EMULATOR);
#endif
}

bool LoadRom(char* file)
{
	FILE* rom;
	rom = fopen(file,"rb");
	if (!rom) return 1;

	fseek(rom,0,SEEK_END);
	rom_length = ftell(rom) + 0x200;
	fseek(rom,0,SEEK_SET);

#pragma warning (disable: 4267)
	fread(memory+0x200,1,rom_length-0x200,rom);
#pragma warning (default: 4267)
	
	fseek(rom,0,SEEK_SET);
	fread(&signature,1,8,rom);
	fclose(rom);

	if ( (memory[PC]<<8)+(memory[PC+1])==0x2A2A )
	{
		//MessageBox(NULL,"Corrupt rom or not a chip8 rom.",emu_title,MB_ICONERROR);
		return false;
	}
	
	for (int i=0; i<80; i++)
		memory[Chip8FontAddress+i] = Chip8Font[i];
	for (int i=0; i<160; i++)
		memory[SChip8FontAddress+i] = SChip8Font[i];

	bRomLoaded = true;
	return true;
}

bool CloseRom()
{
	ZeroMemory(memory,sizeof(memory));
	ZeroMemory(screen,sizeof(screen));
	ZeroMemory(V,sizeof(V));
	PC = 0x200;
	I = 0x0;
	DT = 0;
	ST = 0;
	srand( GetTickCount() );
	//pd3dDevice->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	bRomLoaded = false;
	return true;
}

int soundinited = 0 ;
#define SAMPLE_RATE 40000

LPDIRECTSOUND8 lpDS;
LPDIRECTSOUNDBUFFER m_Primary;

#include "beep.h"

void InitSound( )
{
	m_StreamSample = 0 ;

	if (soundinited )
		return ;

	if( DirectSoundCreate(NULL,&lpDS,NULL) != DS_OK )
	{
		lpDS = NULL;
		return ;
	}

    WAVEFORMATEX wfx;
    ZeroMemory( &wfx, sizeof(WAVEFORMATEX) ); 
    wfx.wFormatTag      = (WORD) WAVE_FORMAT_PCM; 
    wfx.nChannels       = (WORD) 1;
    wfx.nSamplesPerSec  = (DWORD) 40000;
    wfx.wBitsPerSample  = (WORD) 8; 
    wfx.nBlockAlign     = (WORD) (wfx.wBitsPerSample / 8 * wfx.nChannels);
    wfx.nAvgBytesPerSec = (DWORD) (wfx.nSamplesPerSec * wfx.nBlockAlign);

	DSBUFFERDESC dsbd;
	ZeroMemory( &dsbd, sizeof( DSBUFFERDESC ) );
	dsbd.dwSize = sizeof(DSBUFFERDESC);
	dsbd.dwFlags = 0 ; //DSBCAPS_CTRLPOSITIONNOTIFY  ; //DSBCAPS_GETCURRENTPOSITION2 | DSBCAPS_CTRLPOSITIONNOTIFY ;
	dsbd.dwBufferBytes = 1600 ; //40000*40/1000;
	dsbd.lpwfxFormat = &wfx;

	if( lpDS->CreateSoundBuffer( &dsbd, &m_Primary, NULL ) != DS_OK )
	{
		lpDS->Release();
		lpDS = NULL;
		return ;
	}

	char *bt1;
	long bc1;
	if ( m_Primary->Lock( 0, 1600,
		(LPVOID*)&bt1, (LPDWORD)&bc1,
		NULL, NULL,
		0 ) == DS_OK )
	{
		memcpy( bt1, beepwav, bc1 ) ;
		m_Primary->Unlock((LPVOID)bt1, bc1, NULL, 0);
	}

	soundinited = 1 ;
}

bool InitEmu(char* file)
{
	InitSound() ;

	//TRACE("Initializing emulation...\n");
	if ( !InitD3D() )
		return false;
	if ( !InitDInput() )
		return false;

	CloseRom();
	//LoadRom(file);

	//nRegDelay = 20; //0-40
	dwPixelColor = 0xFFFF0000;
#if 0
	HKEY hkey = NULL;
	LONG lRet;
	DWORD size = sizeof(nRegDelay);
	lRet = RegOpenKeyEx(HKEY_CURRENT_USER,"Software\\Doom's infested key\\Chuit",0,KEY_READ,&hkey);
	if (hkey)
	{
		lRet = RegQueryValueEx(hkey,"Register delay",0,NULL,(BYTE*)&nRegDelay,&size);
		size = sizeof(dwPixelColor);
		lRet = RegQueryValueEx(hkey,"Pixel color",0,NULL,(BYTE*)&dwPixelColor,&size);
		if (lRet != ERROR_SUCCESS)
		{
			//MessageBox(hwndDlg,"Failed to retrieve the options from registry! Make sure you have proper read permissions in the registry!",emu_title,MB_ICONERROR);
			nRegDelay = 20;
			dwPixelColor = 0xFFFF0000;
		}
	}
	RegCloseKey(hkey);
#endif
	return true;
}

void Shutdown()
{
	//TRACE("Shutting down emulation...\n");
	//DestroyD3D();
	//DestroyDInput();
}

#include "opcodes.h"

inline void cpu()
{
	try
	{ opcode = ((memory[PC]<<8) + memory[PC+1]); }
	catch(...)
	{ 
#if 0
		char msg[1000];
		if (PC > 0xFFF)
			wsprintf(msg,"Critical error: trying to read beyond console memory at 0x%X!",PC);
		else if (PC > rom_length)
			wsprintf(msg,"Critical error: trying to read beyond rom memory at 0x%X!",PC);
		wsprintf(msg,"%s0x%X!\nLast opcode processed was 0x%X at location 0x%X.\nRom memory is mapped at 0x200 through 0x%X.",
		msg,PC,lastOpcode,lastPC,rom_length);
		RenderText(msg,DT_CRITICAL_ERROR|QUIT_EMULATOR);
#endif
	}
	JumpTableBasic[ (opcode & 0xF000)>>12 ]();
	//CPUTRACE(opcode);
	//OpCodes.push_back(opcode);
	//valid_addr_or_op(opcode,type_opcode);
	//if (bExit) return;
	//switch (opcode&0xF000)
	//{
	//	case 0x0000: Opcode00(); break; // Various opcodes
	//	case 0x1000: Opcode01(); break; // Jump to XXX
	//	case 0x2000: Opcode02(); break; // Jump to subroutine at XXX
	//	case 0x3000: Opcode03(); break; // Skip if register X = XXX
	//	case 0x4000: Opcode04(); break; // Skip if register X <> XXX
	//	case 0x5000: Opcode05(); break; // Skip if register X = Y
	//	case 0x6000: Opcode06(); break; // Move XXX to register X
	//	case 0x7000: Opcode07(); break; // Add XXX to register X
	//	case 0x8000: Opcode08(); break; // Math opcodes
	//	case 0x9000: Opcode09(); break; // Skip if register X <> Y
	//	case 0xA000: Opcode0A(); break; // Load I with XXX
	//	case 0xB000: Opcode0B(); break; // Jump to XXX + V[0] 
	//	case 0xC000: Opcode0C(); break; // Move random number less than or equal to XXX to register X
	//	case 0xD000: Opcode0D(); break; // Draw sprite at screen location X,Y, height S
	//	case 0xE000: Opcode0E(); break; // Key opcodes
	//	case 0xF000: Opcode0F(); break; // Various opcodes
	//	default: UnknownInstruction(); break;
	//}
	//if (PC == StopPC)
	//{
	//	TRACE("EmulationThread: Breakpoint set. Halting execution...\n");
	//	Break();
	//}
	lastOpcode = opcode;
	lastPC = PC;
	PC += 2;
}

#define CPU_FREQ                      4000000

void Beep( DWORD freq, DWORD duration )
{
#if 0
	char *bt1=NULL;
	long bc1=0;

	freq+=3000 ;

	if ( m_Primary->Lock( 0, 1600,
		(LPVOID*)&bt1, (LPDWORD)&bc1, NULL, NULL,0 ) == DS_OK )
	{
		if( freq == 0 ) 
			memset( bt1, 0, bc1);
		else 
		{

			int i;
			unsigned char v = 0x00;
			int f = 0;

			//sound_freq+=3000 ;

			for(i=0; i < bc1; i++)
			{
				f += freq;
				while(f >= 40000)
				{
					if ( v )
						v = 0x80 ;
					else
						v = 0 ;
					//v ^= 0xff;
					f -= 40000;
				}

				bt1[i] = v ;
				//uv = (unsigned char)v ;
				//newval = (short)((uv+(uv << 8))-32768);
				//*stream++ = v;
			}
		}




#if 0
			for( int i = 0; i < bc1 ; i++ )
			{		
				m_StreamSample = (m_StreamSample + CPU_FREQ / SAMPLE_RATE) % freq;
				bt1[i] = m_StreamSample < duty ? 0 : 0x80;
			}
#endif
		m_Primary->Unlock((LPVOID)bt1, bc1, 0, 0 ) ;
	}
#endif ;

	m_Primary->Play( 0, 0, 0 );
	//Sleep( duration ) ;


}
extern "C" int xbox_check_events() ;
extern "C" unsigned int xbox_read_port( int which ) ;

unsigned int portval ;

extern char *g_filename ;
extern bool bExitAndEmulate ;
extern bool bEmulate ;

DWORD lastTick = 0 ;

DWORD WINAPI EmulationThread(LPVOID lParam)
{
	static int slowdown = 0;
	if (bRenderingText) return 0;
	cpu();
	if (slowdown >= nRegDelay)
	{
		if (ST==1) Beep(150,40);
		if (DT) DT--;
		if (ST) ST--;
		slowdown = 0;
	}
	slowdown++;
	GetKeyboardState();

	if ( lastTick+15 < GetTickCount() )
	{
		lastTick = GetTickCount() ;
		bExit = xbox_check_events()  ;
		portval = xbox_read_port( 0 ) ;

		for ( int k =0 ; k < 16 ; k++ )
		{
			if ( portval & (1<<k) )
			{
				keys[k] = 1 ;
			}
			else
				keys[k] = 0 ;
		}

		if ( portval & 0x10000 )
		{
				if (!InitEmu(g_filename)) return 0 ;

				if ( ! LoadRom( g_filename ) )
					return 0 ;
				bEmulate = true;
				bExitAndEmulate = true;
				bRealQuit = false ;
		}
	}
	return 0;
}

void chip8savestate( char *filename )
{
	FILE* fState = fopen(filename,"wb");

	if ( fState == NULL )
		return ;

	fwrite(&HP48Pointer,sizeof(uint),1,fState);
	fwrite(&iRoutinesJumped,sizeof(uint),1,fState);
	fwrite(&I,sizeof(uint),1,fState);
	fwrite(&V,16,1,fState);
	fwrite(&memory,0xFFF,1,fState);
	fwrite(&screen,128*64,1,fState);
	fwrite(&PC,sizeof(uint),1,fState);
	fwrite(&DT,sizeof(uint),1,fState);
	fwrite(&ST,sizeof(uint),1,fState);
	fwrite(&bExtendedScreen,1,1,fState);
	fwrite(&stack,sizeof(uint)*16,1,fState);
	fclose(fState);
}
void chip8loadstate( char *filename )
{
	FILE* fState = fopen(filename,"rb");

	if ( fState == NULL )
		return ;

	fread(&HP48Pointer,sizeof(uint),1,fState);
	fread(&iRoutinesJumped,sizeof(uint),1,fState);
	fread(&I,sizeof(uint),1,fState);
	fread(&V,16,1,fState);
	fread(&memory,0xFFF,1,fState);
	fread(&screen,128*64,1,fState);
	fread(&PC,sizeof(uint),1,fState);
	fread(&DT,sizeof(uint),1,fState);
	fread(&ST,sizeof(uint),1,fState);
	fread(&bExtendedScreen,1,1,fState);
	fread(&stack,sizeof(uint)*16,1,fState);
	fclose(fState);
	bEmulate = true;
	bRealQuit = false ;
	RenderScreen();
}

extern "C" size_t xbox_mfread( const void *buffer, size_t len1, size_t len2, void *st ) ;
extern "C" size_t xbox_mfwrite( const void *buffer, size_t len1, size_t len2, void *st ) ;

extern "C" void xbox_loadstatemem( void *fState)
{
	xbox_mfread(&HP48Pointer,sizeof(uint),1,fState);
	xbox_mfread(&iRoutinesJumped,sizeof(uint),1,fState);
	xbox_mfread(&I,sizeof(uint),1,fState);
	xbox_mfread(&V,16,1,fState);
	xbox_mfread(&memory,0xFFF,1,fState);
	xbox_mfread(&screen,128*64,1,fState);
	xbox_mfread(&PC,sizeof(uint),1,fState);
	xbox_mfread(&DT,sizeof(uint),1,fState);
	xbox_mfread(&ST,sizeof(uint),1,fState);
	xbox_mfread(&bExtendedScreen,1,1,fState);
	xbox_mfread(&stack,sizeof(uint)*16,1,fState);
	bEmulate = true;
	bRealQuit = false ;
}

extern "C" void xbox_savestatemem( void *fState)
{
	xbox_mfwrite(&HP48Pointer,sizeof(uint),1,fState);
	xbox_mfwrite(&iRoutinesJumped,sizeof(uint),1,fState);
	xbox_mfwrite(&I,sizeof(uint),1,fState);
	xbox_mfwrite(&V,16,1,fState);
	xbox_mfwrite(&memory,0xFFF,1,fState);
	xbox_mfwrite(&screen,128*64,1,fState);
	xbox_mfwrite(&PC,sizeof(uint),1,fState);
	xbox_mfwrite(&DT,sizeof(uint),1,fState);
	xbox_mfwrite(&ST,sizeof(uint),1,fState);
	xbox_mfwrite(&bExtendedScreen,1,1,fState);
	xbox_mfwrite(&stack,sizeof(uint)*16,1,fState);
}

